class AdvancedUserRecipe1289709253(BasicNewsRecipe):
    title          = u'Global TV Calgary'
    oldest_article = 7
    max_articles_per_feed = 100
    use_embedded_content  = False
    no_stylesheets = True
    encoding              = 'utf8'

    remove_javascript     = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        h2{font-family:Georgia,serif; font-weight:normal;font-size:small;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''

    keep_only_tags = [dict(id=['mainContent','storypage'])]
    remove_tags = [dict(name='div', attrs={'class':['copyright','storyTools','byline','storytab','imagetext','story_tool_hr','relatedLinks relatedShort','clear','col_160','col_620','rule_grey_solid']}),
                   dict(name='div', attrs={'id':['photoBox','terColumn','imageBox','story_photo_content','breadcrumbs']}),
                   dict(name='img'),]
    feeds          = [(u'News', u'http://rss.canada.com/get/?F8171'),
                           (u'World News', u'http://rss.canada.com/get/?F77'),
                           (u'National', u'http://rss.canada.com/get/?F75'),
                           (u'Entertainment', u'http://rss.canada.com/get/?F69'),
                           (u'Lifestyle', u'http://rss.canada.com/get/?F184'),
                           (u'Health', u'http://rss.canada.com/get/?F67'),
                           (u'Technology', u'http://rss.canada.com/get/?F72')
]

                         
						  
    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup



    def parse_feeds (self): 
      feeds = BasicNewsRecipe.parse_feeds(self) 
      for feed in feeds:
        for article in feed.articles[:]:
          print 'article.title is: ', article.title
          if 'GALLERY' in article.title.upper():
            feed.articles.remove(article)
          elif 'VIDEO' in article.url.upper():
            feed.articles.remove(article)
      return feeds